PSCAD 4.2.0

Settings
 {
 Id = "976141504.1144771837"
 Author = "jayas.jayas"
 Desc = "Parallel Transmission Lines using Mutual Coupling"
 Arch = "windows"
 Options = 0
 Build = 19
 Warn = 7
 Check = 15
 Libs = ""
 Source = ""
 RunInfo = 
  {
  Fin = 0.5
  Step = 5e-005
  Plot = 5e-005
  Chat = 0.001
  Brch = 0.0005
  Lat = 100
  Options = 0
  Advanced = 511
  Debug = 0
  StartFile = ""
  OFile = "case3_Mutual.out"
  SFile = "noname.snp"
  SnapTime = 0.3
  Mruns = 10
  Mrunfile = 0
  StartType = 0
  PlotType = 0
  SnapType = 0
  MrunType = "mrun"
  }


Global_Consts = 
  {
  f = 60.0 [Hz]
  }

 }

Definitions
 {
 Module("Controls")
  {
  Desc = ""
  FileDate = 1144771582
  Nodes = 
   {
   Output("F",36,18)
    {
    Type = Integer
    }
   Output("B",36,-36)
    {
    Type = Integer
    Dim  = [4]
    }
   Input("Flt_en",36,-18)
    {
    Type = Integer
    }
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Pen(Gray)
   Line(27,28,27,-43)
   Brush(,Silver)
   Rectangle(0,-13,3,0)
   Brush(,Gray)
   Rectangle(-3,-10,6,-7)
   Text(1,25,"Controls")
   Pen(Black)
   Line(27,18,36,18)
   Line(27,-36,36,-36)
   Line(34,-18,27,-18)
   Pen(ByNode)
   Brush(Hollow)
   Rectangle(-4,-18,7,3)
   }


  Page(B/A3,Landscape,16,[597,467],100)
   {
   -Sticky-([72,666],0)
    {
    Name = ""
    Font = 1
    Bounds = 72,666,180,702
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "FAULT CONTROLS"
    }
   0.export([1548,1134],4,0,300)
    {
    Name = "F"
    }
   -Wire-([648,684],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([684,684],0,0,-1)
    {
    Name = "Tfs"
    }
   0.datalabel([684,720],0,0,-1)
    {
    Name = "Tfd"
    }
   0.datalabel([810,702],4,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([1458,1134],4,0,-1)
    {
    Name = "Fault"
    }
   -Wire-([1458,1134],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -ControlPanel-([18,396],0)
    {
    Name = "SOURCE 2"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,576,126
    Slider(36406632)
    Meter(36450768)
    Slider(36399808)
    Meter(36342288)
    Meter(36174704)
    Meter(36202008)
    Meter(36320448)
    Meter(36323368)
    }
   -Sticky-([522,108],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 522,108,684,216
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Adjust phase angle to obtain
the correct power flow. Adjust
voltage to obtain the matching
VAR flow at each end."
    }
   0.arrow_a([522,216],1,0,-1)
    {
    }
   -ControlPanel-([72,720],0)
    {
    Name = "Fault Location, Type, Start & Duration"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,432,126
    Dial(36353584)
    Dial(36385424)
    Slider(35592408)
    Slider(35595560)
    Slider(36469416)
    }
   0.datalabel([1566,738],3,0,-1)
    {
    Name = "B3T1"
    }
   0.datalabel([1566,792],3,0,-1)
    {
    Name = "B3T2"
    }
   0.datalabel([1566,846],3,0,-1)
    {
    Name = "B4T1"
    }
   0.datalabel([1458,990],6,0,-1)
    {
    Name = "B1"
    }
   0.datalabel([1458,1008],6,0,-1)
    {
    Name = "B2"
    }
   0.datalabel([1458,1026],6,0,-1)
    {
    Name = "B3"
    }
   0.datalabel([1458,1044],6,0,-1)
    {
    Name = "B4"
    }
   0.datamerge([1476,1062],4,0,290)
    {
    N = "4"
    Type = "1"
    Disp = "1"
    }
   0.export([1512,1080],4,0,310)
    {
    Name = "B"
    }
   -Wire-([648,720],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -ControlPanel-([1296,270],0)
    {
    Name = "B1 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(35527352)
    Slider(35545168)
    Slider(35538640)
    }
   -ControlPanel-([1296,414],0)
    {
    Name = "B2 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(35531248)
    Slider(35541416)
    Slider(35583384)
    }
   0.datalabel([1566,900],3,0,-1)
    {
    Name = "B4T2"
    }
   -ControlPanel-([1296,648],0)
    {
    Name = "B3 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(35552864)
    Slider(35558816)
    Slider(35484632)
    }
   -ControlPanel-([1296,792],0)
    {
    Name = "B4 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(35561216)
    Slider(35481776)
    Slider(35478624)
    }
   0.var([1530,900],0,35478624,160)
    {
    Name = "B4T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.var([1530,846],0,35481776,140)
    {
    Name = "B4T1"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "0.35"
    Units = "s"
    Collect = "1"
    }
   0.var([1530,792],0,35484632,120)
    {
    Name = "B3T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.tfaultn([774,702],4,0,230)
    {
    TF = "Tfs"
    DF = "Tfd"
    }
   -Sticky-([18,198],0)
    {
    Name = ""
    Font = 1
    Bounds = 18,198,144,234
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "PREFAULT CONTROLS"
    }
   -ControlPanel-([18,252],0)
    {
    Name = "SOURCE 1"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,576,126
    Slider(36393968)
    Meter(36445056)
    Slider(36396952)
    Meter(36339376)
    Meter(36348048)
    Meter(36204992)
    Meter(36390592)
    Meter(36317536)
    }
   -Wire-([1836,504],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1836,324],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.logic([1872,504],6,0,220)
    {
    Type = "1"
    Inv = "0"
    }
   0.logic([1872,324],0,0,200)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([1908,324],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.var_switch([1908,288],0,35527352,10)
    {
    Name = "42-B1"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   0.datalabel([2016,324],4,0,-1)
    {
    Name = "B1"
    }
   -Wire-([1908,504],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.var_switch([1908,450],6,35531248,50)
    {
    Name = "42-B2"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   -Wire-([1944,468],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   0.datalabel([2016,468],2,0,-1)
    {
    Name = "B2"
    }
   0.tbreakn([1782,324],4,0,190)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B1T1"
    TO2 = "B1T2"
    }
   0.datalabel([1566,360],3,0,-1)
    {
    Name = "B1T1"
    }
   0.datalabel([1566,414],3,0,-1)
    {
    Name = "B1T2"
    }
   0.datalabel([1566,468],3,0,-1)
    {
    Name = "B2T1"
    }
   0.var([1530,414],0,35538640,30)
    {
    Name = "B1 T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.var([1530,468],0,35541416,40)
    {
    Name = "B2 T1"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.datalabel([1566,522],3,0,-1)
    {
    Name = "B2T2"
    }
   0.var([1530,360],0,35545168,20)
    {
    Name = "B1 T1"
    Group = ""
    Display = "0"
    Max = "2"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   -Sticky-([1440,180],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 1440,180,1602,252
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Adjust breaker clearing time (T1)
and reclose time (T2) if needed."
    }
   0.logic([1980,324],6,0,210)
    {
    Type = "2"
    Inv = "0"
    }
   -Wire-([1836,900],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1836,720],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1836,756],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   0.logic([1872,900],6,0,180)
    {
    Type = "1"
    Inv = "0"
    }
   0.logic([1872,720],0,0,250)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([1908,720],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.var_switch([1908,684],0,35552864,100)
    {
    Name = "42-B3"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   -Wire-([1908,900],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1944,864],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   0.datalabel([2016,720],4,0,-1)
    {
    Name = "B3"
    }
   0.datalabel([2016,864],2,0,-1)
    {
    Name = "B4"
    }
   0.var([1530,738],0,35558816,110)
    {
    Name = "B3T1"
    Group = ""
    Display = "0"
    Max = "2"
    Min = "0.0"
    Value = "0.35"
    Units = "s"
    Collect = "1"
    }
   0.var_switch([1908,846],6,35561216,150)
    {
    Name = "42-B4"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   0.tbreakn([1782,900],4,0,170)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B4T1"
    TO2 = "B4T2"
    }
   0.logic([1980,720],6,0,260)
    {
    Type = "2"
    Inv = "0"
    }
   -ControlPanel-([936,180],0)
    {
    Name = "Recorders"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,144,126
    Slider(36504136)
    Slider(36494392)
    }
   0.var([1530,522],0,35583384,60)
    {
    Name = "B2 T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.tbreakn([1782,720],4,0,240)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B3T1"
    TO2 = "B3T2"
    }
   0.logic([1980,468],0,0,280)
    {
    Type = "2"
    Inv = "0"
    }
   0.tbreakn([1782,504],4,0,70)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B2T1"
    TO2 = "B2T2"
    }
   -Wire-([1836,360],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   -Wire-([1710,414],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   0.logic([1980,864],0,0,270)
    {
    Type = "2"
    Inv = "0"
    }
   0.import([1674,810],0,0,130)
    {
    Name = "Flt_en"
    }
   -Wire-([1710,414],0,0,-1)
    {
    Vertex="0,0;0,396"
    }
   -Wire-([1710,810],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   0.var([612,684],0,35592408,80)
    {
    Name = "Fault Start "
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.2"
    Units = "s"
    Collect = "1"
    }
   0.var([612,720],0,35595560,90)
    {
    Name = "Duration "
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.21"
    Units = ""
    Collect = "1"
    }
   -Sticky-([72,864],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 72,864,234,1170
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Dial Position:
  1=> FT1:
          Between Source
          and  B1
  2=> FT2: 
          Between B1 
          and Line
  3=> FT3: 
          Between Line 1
          and B2
  4=> FT4: 
          Between Source
          and B2
  5=> FT5:
          Between B3
          and Line 2
  6=> FT6:
          Between Line 2 
          and B4  "
    }
   -Sticky-([270,864],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 270,864,378,1080
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Dial Position:
  1=> A-g
  2=> B-g
  3=> C-g
  4=> AB-g
  5=> AC-g
  6=> BC-g
  7=> ABC-g
  8=> AB 
  9=> AC 
10=>No Fault
11=> No fault (0)"
    }
   -Sticky-([882,594],0)
    {
    Name = ""
    Font = 1
    Bounds = 882,594,1170,936
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Example of a Test  Sequence 

Fault is located on Line 2 at B3 (Fault location 5)
Fault is 3 phase to Ground (Fault Type 7)

Fault occurs at 0.30 sec,  Fault Duration 0.05 sec.

Set Breakers:
B1T1 =  2.00:  Breaker B1 does not trip
B2T1 =  2.00:  Breaker B2 does not trip
B3T1 =  0.35:  Breaker B3 trips in 35 msec
B4T1 =  0.40:  Breaker B4 trips in 40 msec
B1T2 =  2.00:  Breaker B1 does not reclose
B2T2 =  2.00:  Breaker B2 does not reclose
B3T2 =  2.00:  Breaker B3 does not reclose        
B4T2 =  2.00:  Breaker B4 does not reclose        

(Breaker  B1 and B2 do not operate automatically)
"
    }
   -Sticky-([1296,990],0)
    {
    Name = ""
    Font = 1
    Bounds = 1296,990,1404,1026
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Exports to Main Page"
    }
   -Sticky-([1296,180],0)
    {
    Name = ""
    Font = 1
    Bounds = 1296,180,1404,216
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "BREAKER CONTROLS"
    }
   -Sticky-([936,126],0)
    {
    Name = ""
    Font = 1
    Bounds = 936,126,1062,162
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "COMTRADE Recorders"
    }
   -ControlPanel-([864,342],0)
    {
    Name = "Recorder Control"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,288,126
    Switch(36511280)
    Switch(36514168)
    Switch(36516896)
    Switch(36519616)
    }
   -Sticky-([882,486],0)
    {
    Name = ""
    Font = 1
    Bounds = 882,486,1134,576
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
To turn the Recorders on, click on the switch.
On = Recorder will record data.
Off = Recorder will NOT record data.

You can turn on or off each recorder individually."
    }
   -Divider-([0,576],0)
    {
    Size(1206,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([1206,54],0)
    {
    Size(0,1494)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([1206,954],0)
    {
    Size(1206,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([774,54],0)
    {
    Size(0,522)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   }
  }
 Module("Plots_B2")
  {
  Desc = ""
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Line(-13,-1,-13,-21)
   Line(-13,-4,-4,-13)
   Line(-4,-13,1,-10)
   Line(6,-16,12,-13)
   Pen(Gray)
   Line(27,28,27,-43)
   Pen(Black)
   Line(1,-10,6,-16)
   Line(-18,-4,21,-4)
   Text(1,-28,"Plots")
   Text(3,24,"B2 B4")
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   -Plot-([18,18],0)
    {
    Title = "Plots at B2"
    Draw = 1
    Area = [0,0,738,1188]
    Posn = [18,18]
    Icon = [-1,-1]
    Extents = 0,0,738,1188
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,738,286],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(36136728,"V2a",0,,,)
     Curve(36465136,"V2b",1,,,)
     Curve(36166824,"V2c",2,,,)
     }
    Graph([0,286],[0,0,738,286],"Current")
     {
     Options = 9
     Units = ""
     Curve(36128128,"I2a",0,,,)
     Curve(36130904,"I2b",1,,,)
     Curve(36221240,"I2c",2,,,)
     }
    Graph([0,572],[0,0,738,286],"Current")
     {
     Options = 9
     Units = ""
     Curve(36218464,"I20",0,,,)
     }
    PGraph([0,858],[0,0,738,267],"PolyGraph")
     {
     Options = 2
     Curve(36146864,"Br2a",0,,,1)
     Curve(36158896,"Br2b",1,,,1)
     Curve(36149504,"Br2c",2,,,1)
     }
    }
   -Plot-([810,18],0)
    {
    Title = "Plots at B4"
    Draw = 1
    Area = [0,0,738,1188]
    Posn = [810,18]
    Icon = [-1,-1]
    Extents = 0,0,738,1188
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,738,286],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(36291448,"V4a",0,,,)
     Curve(36294360,"V4b",1,,,)
     Curve(36462040,"V4c",2,,,)
     }
    Graph([0,286],[0,0,738,286],"Current")
     {
     Options = 9
     Units = ""
     Curve(36297272,"I4a",0,,,)
     Curve(36300184,"I4b",1,,,)
     Curve(36303440,"I4c",2,,,)
     }
    Graph([0,572],[0,0,738,286],"Current")
     {
     Options = 9
     Units = ""
     Curve(36306296,"I40",0,,,)
     }
    PGraph([0,858],[0,0,738,267],"PolyGraph")
     {
     Options = 2
     Curve(36068648,"Br4a",0,,,1)
     Curve(36326280,"Br4b",1,,,1)
     Curve(36328944,"Br4c",2,,,1)
     }
    }
   }
  }
 Module("Plots_B1")
  {
  Desc = ""
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Line(-13,-1,-13,-21)
   Line(-18,-4,21,-4)
   Line(-13,-4,-4,-13)
   Line(-4,-13,1,-10)
   Line(6,-16,12,-13)
   Pen(Gray)
   Line(27,28,27,-43)
   Pen(Black)
   Line(1,-10,6,-16)
   Text(1,-28,"Plots")
   Text(3,24,"B1 B3")
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   -Plot-([18,18],0)
    {
    Title = "Plots at B1"
    Draw = 1
    Area = [0,0,738,1170]
    Posn = [18,18]
    Icon = [-1,-1]
    Extents = 0,0,738,1170
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,738,282],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(36336408,"V1a",0,,,)
     Curve(36153176,"V1b",1,,,)
     Curve(36133816,"V1c",2,,,)
     }
    Graph([0,282],[0,0,738,281],"Current")
     {
     Options = 9
     Units = ""
     Curve(36207904,"I1a",0,,,)
     Curve(36224152,"I1b",1,,,)
     Curve(36210736,"I1c",2,,,)
     }
    Graph([0,563],[0,0,738,281],"Current")
     {
     Options = 9
     Units = ""
     Curve(36214656,"I10",0,,,)
     }
    PGraph([0,844],[0,0,738,263],"PolyGraph")
     {
     Options = 2
     Curve(36142192,"Br1a",0,,,1)
     Curve(36155952,"Br1b",1,,,1)
     Curve(36196992,"Br1c",2,,,1)
     }
    }
   -Plot-([810,18],0)
    {
    Title = "Plots at B3"
    Draw = 1
    Area = [0,0,738,1170]
    Posn = [810,18]
    Icon = [-1,-1]
    Extents = 0,0,738,1170
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,738,282],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(36270976,"V3a",0,,,)
     Curve(36273976,"V3b",1,,,)
     Curve(36276888,"V3c",2,,,)
     }
    Graph([0,282],[0,0,738,281],"Current")
     {
     Options = 9
     Units = ""
     Curve(36279800,"I3a",0,,,)
     Curve(36282712,"I3b",1,,,)
     Curve(36285624,"I3c",2,,,)
     }
    Graph([0,563],[0,0,738,281],"Current")
     {
     Options = 9
     Units = ""
     Curve(36288536,"I30",0,,,)
     }
    PGraph([0,844],[0,0,738,263],"PolyGraph")
     {
     Options = 2
     Curve(36309208,"Br3a",0,,,1)
     Curve(36311984,"Br3b",1,,,1)
     Curve(36314760,"Br3c",2,,,1)
     }
    }
   }
  }
 Module("Main")
  {
  Desc = "Main Page"
  FileDate = 1144771582
  Nodes = 
   {
   }

  Graphics = 
   {
   Rectangle(-18,-18,18,18)
   }


  Page(B/A3,Landscape,16,[597,467],100)
   {
   0.pgb([2322,1242],0,36068648,1110)
    {
    Name = "Br4a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.datalabel([396,1152],2,0,-1)
    {
    Name = "I1A"
    }
   0.datalabel([432,1152],2,0,-1)
    {
    Name = "I1B"
    }
   0.datalabel([468,1152],2,0,-1)
    {
    Name = "I1C"
    }
   0.datalabel([396,1332],2,0,-1)
    {
    Name = "I2A"
    }
   0.datalabel([432,1332],2,0,-1)
    {
    Name = "I2B"
    }
   0.datalabel([468,1332],2,0,-1)
    {
    Name = "I2C"
    }
   -Wire-([1836,1206],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datatap([1854,1242],0,0,340)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1854,1278],0,0,440)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([288,1152],2,0,-1)
    {
    Name = "V1A"
    }
   0.datalabel([324,1152],2,0,-1)
    {
    Name = "V1B"
    }
   0.datalabel([360,1152],2,0,-1)
    {
    Name = "V1C"
    }
   0.datalabel([288,1332],6,0,-1)
    {
    Name = "V2A"
    }
   0.datalabel([324,1332],6,0,-1)
    {
    Name = "V2B"
    }
   0.datalabel([360,1332],6,0,-1)
    {
    Name = "V2C"
    }
   -Wire-([2286,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2286,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2286,1314],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2286,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1998,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1998,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1998,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1872,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1872,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1872,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2160,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2160,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2160,1314],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2160,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2160,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datatap([1980,1314],0,0,520)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1980,1278],0,0,480)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1980,1242],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1980,1278],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1980,1314],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1854,1314],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1854,1278],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1854,1242],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datatap([1854,1314],0,0,500)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1980,1242],0,0,360)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1962,1206],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datalabel([1134,1134],2,0,-1)
    {
    Name = "B2"
    }
   0.datalabel([1044,1224],2,0,-1)
    {
    Name = "FT1"
    }
   0.datalabel([1080,1224],2,0,-1)
    {
    Name = "FT2"
    }
   0.datalabel([1116,1224],2,0,-1)
    {
    Name = "FT3"
    }
   -Wire-([1098,1314],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   0.datalabel([1044,1476],0,0,-1)
    {
    Name = "F1"
    }
   0.datalabel([1080,1476],0,0,-1)
    {
    Name = "F2"
    }
   0.datalabel([1116,1476],0,0,-1)
    {
    Name = "F3"
    }
   0.datalabel([1134,1386],2,0,-1)
    {
    Name = "Fault"
    }
   -Wire-([1404,180],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   -Wire-([1998,1476],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1872,1476],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([324,738],0,0,-1)
    {
    Name = "FT1"
    }
   0.datalabel([324,756],0,0,-1)
    {
    Name = "F1"
    }
   0.datalabel([972,540],0,0,-1)
    {
    Name = "FT3"
    }
   0.datalabel([972,558],0,0,-1)
    {
    Name = "F3"
    }
   0.datalabel([972,774],0,0,-1)
    {
    Name = "FT6"
    }
   0.datalabel([972,792],0,0,-1)
    {
    Name = "F6"
    }
   0.datalabel([1170,1134],2,0,-1)
    {
    Name = "B3"
    }
   0.datalabel([1098,1134],2,0,-1)
    {
    Name = "B1"
    }
   0.datalabel([1188,1224],2,0,-1)
    {
    Name = "FT5"
    }
   0.datalabel([1224,1476],0,0,-1)
    {
    Name = "F6"
    }
   0.breaker3([1098,522],0,0,680)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B2"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I2A"
    IBRB = "I2B"
    IBRC = "I2C"
    IBR0 = "I20"
    SBRA = "Br2A"
    SBRB = "Br2B"
    SBRC = "Br2C"
    BP = "P2"
    BQ = "Q2"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "118.7 [MW]"
    Q = "-19.72 [MVAR]"
    }
   0.datalabel([540,540],0,0,-1)
    {
    Name = "FT2"
    }
   0.datalabel([540,558],0,0,-1)
    {
    Name = "F2"
    }
   0.datalabel([540,774],0,0,-1)
    {
    Name = "FT5"
    }
   -Wire-([522,738],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   0.breaker3([414,522],4,0,690)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B1"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I1A"
    IBRB = "I1B"
    IBRC = "I1C"
    IBR0 = "I10"
    SBRA = "Br1A"
    SBRB = "Br1B"
    SBRC = "Br1C"
    BP = "P1"
    BQ = "Q1"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "-116.7 [MW]"
    Q = "14.69 [MVAR]"
    }
   -Wire-([234,1440],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([1314,1368],0,0,-1)
    {
    Name = "I1A"
    }
   0.datalabel([1314,1404],0,0,-1)
    {
    Name = "I1B"
    }
   0.datalabel([1314,1440],0,0,-1)
    {
    Name = "I1C"
    }
   0.datalabel([1440,1368],0,0,-1)
    {
    Name = "I2A"
    }
   0.datalabel([1440,1404],0,0,-1)
    {
    Name = "I2B"
    }
   0.pgb([1476,1368],0,36128128,1040)
    {
    Name = "I2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.5"
    Max = "2.0"
    }
   0.pgb([1476,1404],0,36130904,980)
    {
    Name = "I2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.5"
    Max = "2.0"
    }
   0.pgb([1350,1314],0,36133816,390)
    {
    Name = "V1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([1476,1242],0,36136728,260)
    {
    Name = "V2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.datalabel([1602,1242],0,0,-1)
    {
    Name = "Br1A"
    }
   0.datalabel([1602,1278],0,0,-1)
    {
    Name = "Br1B"
    }
   0.datalabel([1602,1314],0,0,-1)
    {
    Name = "Br1C"
    }
   0.pgb([1638,1242],0,36142192,1170)
    {
    Name = "Br1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datalabel([1728,1242],0,0,-1)
    {
    Name = "Br2A"
    }
   0.datalabel([1728,1278],0,0,-1)
    {
    Name = "Br2B"
    }
   0.pgb([1764,1242],0,36146864,1160)
    {
    Name = "Br2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([1764,1314],0,36149504,1080)
    {
    Name = "Br2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datalabel([1602,1368],0,0,-1)
    {
    Name = "P1"
    }
   0.pgb([1350,1278],0,36153176,290)
    {
    Name = "V1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([1638,1278],0,36155952,1140)
    {
    Name = "Br1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([1764,1278],0,36158896,1130)
    {
    Name = "Br2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datatap([1296,1242],0,0,220)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1296,1278],0,0,280)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1278,1206],2,0,-1)
    {
    Name = "V1"
    }
   0.datalabel([1314,1242],2,0,-1)
    {
    Name = "V1A"
    }
   0.datalabel([1314,1278],2,0,-1)
    {
    Name = "V1B"
    }
   0.datalabel([1440,1278],2,0,-1)
    {
    Name = "V2B"
    }
   0.pgb([1476,1314],0,36166824,430)
    {
    Name = "V2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   -Wire-([1602,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1602,1440],0,0,-1)
    {
    Name = "S1W"
    }
   -Wire-([1602,1476],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1602,1476],0,0,-1)
    {
    Name = "S1Q"
    }
   -Wire-([1728,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1728,1476],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1728,1476],0,0,-1)
    {
    Name = "S2Q"
    }
   0.datalabel([1440,1242],2,0,-1)
    {
    Name = "V2A"
    }
   0.pgb([1764,1368],0,36174704,1000)
    {
    Name = "P2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-150"
    Max = "150"
    }
   0.datalabel([1728,1440],0,0,-1)
    {
    Name = "S2W"
    }
   -Wire-([1728,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1728,1404],0,0,-1)
    {
    Name = "Q2"
    }
   -Wire-([1728,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1728,1368],0,0,-1)
    {
    Name = "P2"
    }
   -Wire-([1728,1314],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1728,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1728,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1728,1314],0,0,-1)
    {
    Name = "Br2C"
    }
   0.datalabel([1440,1440],0,0,-1)
    {
    Name = "I2C"
    }
   -Wire-([1440,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1440,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1440,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1314,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1314,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1314,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1602,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1602,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1602,1314],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1602,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1602,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1440,1314],2,0,-1)
    {
    Name = "V2C"
    }
   0.datatap([1422,1314],0,0,410)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1422,1278],0,0,310)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1422,1242],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1422,1278],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1422,1314],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([1314,1314],2,0,-1)
    {
    Name = "V1C"
    }
   -Wire-([1296,1314],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1296,1278],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1296,1242],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datatap([1296,1314],0,0,370)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1602,1404],0,0,-1)
    {
    Name = "Q1"
    }
   0.pgb([1638,1314],0,36196992,1100)
    {
    Name = "Br1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datatap([1422,1242],0,0,250)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1404,1206],2,0,-1)
    {
    Name = "V2"
    }
   -Wire-([1404,1206],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.pgb([1764,1404],0,36202008,930)
    {
    Name = "Q2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   0.pgb([1638,1404],0,36204992,960)
    {
    Name = "Q1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   0.pgb([1350,1368],0,36207904,1060)
    {
    Name = "I1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.5"
    Max = "2.0"
    }
   0.pgb([1350,1440],0,36210736,940)
    {
    Name = "I1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.5"
    Max = "2.0"
    }
   -Wire-([1440,1476],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1314,1476],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.pgb([1350,1476],0,36214656,800)
    {
    Name = "I10"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.3"
    Max = "0.2"
    }
   0.datalabel([1440,1476],0,0,-1)
    {
    Name = "I20"
    }
   0.pgb([1476,1476],0,36218464,770)
    {
    Name = "I20"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.3"
    Max = "0.3"
    }
   0.pgb([1476,1440],0,36221240,900)
    {
    Name = "I2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.5"
    Max = "2.0"
    }
   0.pgb([1350,1404],0,36224152,1010)
    {
    Name = "I1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.5"
    Max = "2.0"
    }
   -Wire-([1278,1206],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datalabel([1314,1476],0,0,-1)
    {
    Name = "I10"
    }
   0.datalabel([1836,1206],2,0,-1)
    {
    Name = "V3"
    }
   0.datalabel([1872,1242],2,0,-1)
    {
    Name = "V3A"
    }
   0.datalabel([1872,1278],2,0,-1)
    {
    Name = "V3B"
    }
   0.datalabel([1872,1314],2,0,-1)
    {
    Name = "V3C"
    }
   0.datalabel([1998,1242],2,0,-1)
    {
    Name = "V4A"
    }
   0.datalabel([1998,1278],2,0,-1)
    {
    Name = "V4B"
    }
   0.datalabel([1998,1314],2,0,-1)
    {
    Name = "V4C"
    }
   0.datalabel([738,1152],2,0,-1)
    {
    Name = "V3A"
    }
   0.datalabel([774,1152],2,0,-1)
    {
    Name = "V3B"
    }
   0.datalabel([810,1152],2,0,-1)
    {
    Name = "V3C"
    }
   0.datalabel([738,1332],6,0,-1)
    {
    Name = "V4A"
    }
   0.datalabel([774,1332],6,0,-1)
    {
    Name = "V4B"
    }
   0.datalabel([810,1332],6,0,-1)
    {
    Name = "V4C"
    }
   0.datalabel([1872,1368],0,0,-1)
    {
    Name = "I3A"
    }
   0.datalabel([1872,1404],0,0,-1)
    {
    Name = "I3B"
    }
   0.datalabel([1872,1440],0,0,-1)
    {
    Name = "I3C"
    }
   0.datalabel([1872,1476],0,0,-1)
    {
    Name = "I30"
    }
   0.datalabel([1998,1368],0,0,-1)
    {
    Name = "I4A"
    }
   0.datalabel([1998,1404],0,0,-1)
    {
    Name = "I4B"
    }
   0.datalabel([1998,1440],0,0,-1)
    {
    Name = "I4C"
    }
   0.datalabel([1998,1476],0,0,-1)
    {
    Name = "I40"
    }
   0.datalabel([846,1152],2,0,-1)
    {
    Name = "I3A"
    }
   0.datalabel([882,1152],2,0,-1)
    {
    Name = "I3B"
    }
   0.datalabel([918,1152],2,0,-1)
    {
    Name = "I3C"
    }
   0.datalabel([846,1332],2,0,-1)
    {
    Name = "I4A"
    }
   0.datalabel([882,1332],2,0,-1)
    {
    Name = "I4B"
    }
   0.datalabel([918,1332],2,0,-1)
    {
    Name = "I4C"
    }
   0.recorder2_0([360,1224],0,0,1260)
    {
    FName = "stn1"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "1"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V1a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V1b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V1c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I1a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I1b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I1c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.datalabel([1350,180],4,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([468,1296],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([468,1476],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([2160,1368],0,0,-1)
    {
    Name = "P3"
    }
   0.datalabel([2160,1404],0,0,-1)
    {
    Name = "Q3"
    }
   0.datalabel([2160,1242],0,0,-1)
    {
    Name = "Br3A"
    }
   0.datalabel([2160,1278],0,0,-1)
    {
    Name = "Br3B"
    }
   0.datalabel([2160,1314],0,0,-1)
    {
    Name = "Br3C"
    }
   -Wire-([2286,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2286,1242],0,0,-1)
    {
    Name = "Br4A"
    }
   0.datalabel([2286,1278],0,0,-1)
    {
    Name = "Br4B"
    }
   0.datalabel([2286,1314],0,0,-1)
    {
    Name = "Br4C"
    }
   0.datalabel([2286,1368],0,0,-1)
    {
    Name = "P4"
    }
   0.datalabel([2286,1404],0,0,-1)
    {
    Name = "Q4"
    }
   0.pgb([1908,1242],0,36270976,350)
    {
    Name = "V3a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-250.0"
    Max = "250.0"
    }
   0.pgb([1908,1278],0,36273976,460)
    {
    Name = "V3b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-250.0"
    Max = "250.0"
    }
   0.pgb([1908,1314],0,36276888,510)
    {
    Name = "V3c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-250.0"
    Max = "250.0"
    }
   0.pgb([1908,1368],0,36279800,970)
    {
    Name = "I3a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-6.0"
    Max = "8.0"
    }
   0.pgb([1908,1404],0,36282712,860)
    {
    Name = "I3b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-6.0"
    Max = "8.0"
    }
   0.pgb([1908,1440],0,36285624,760)
    {
    Name = "I3c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-6.0"
    Max = "8.0"
    }
   0.pgb([1908,1476],0,36288536,710)
    {
    Name = "I30"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.5"
    Max = "2.5"
    }
   0.pgb([2034,1242],0,36291448,380)
    {
    Name = "V4a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "200.0"
    }
   0.pgb([2034,1278],0,36294360,490)
    {
    Name = "V4b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "200.0"
    }
   0.pgb([2034,1368],0,36297272,950)
    {
    Name = "I4a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.5"
    Max = "2.0"
    }
   0.pgb([2034,1404],0,36300184,810)
    {
    Name = "I4b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.5"
    Max = "2.0"
    }
   0.pgb([2034,1440],0,36303440,730)
    {
    Name = "I4c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.5"
    Max = "2.0"
    }
   0.pgb([2034,1476],0,36306296,700)
    {
    Name = "I40"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.2"
    Max = "0.3"
    }
   0.pgb([2196,1242],0,36309208,1120)
    {
    Name = "Br3a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([2196,1278],0,36311984,1070)
    {
    Name = "Br3b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([2196,1314],0,36314760,1020)
    {
    Name = "Br3c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([2196,1404],0,36317536,780)
    {
    Name = "Q3"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   0.pgb([2322,1368],0,36320448,830)
    {
    Name = "P4"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-150"
    Max = "150"
    }
   0.pgb([2322,1404],0,36323368,750)
    {
    Name = "Q4"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   0.pgb([2322,1278],0,36326280,1050)
    {
    Name = "Br4b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([2322,1314],0,36328944,990)
    {
    Name = "Br4c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.datalabel([540,792],0,0,-1)
    {
    Name = "F5"
    }
   0.datalabel([1206,1134],2,0,-1)
    {
    Name = "B4"
    }
   0.breaker3([414,738],4,0,670)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B3"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I3A"
    IBRB = "I3B"
    IBRC = "I3C"
    IBR0 = "I30"
    SBRA = "Br3A"
    SBRB = "Br3B"
    SBRC = "Br3C"
    BP = "P3"
    BQ = "Q3"
    BOpen1 = "2"
    BOpen2 = "2"
    BOpen3 = "2"
    P = "0.03759 [MW]"
    Q = "0.3073 [MVAR]"
    }
   0.pgb([1350,1242],0,36336408,230)
    {
    Name = "V1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([1638,1152],0,36339376,170)
    {
    Name = "V1rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   0.pgb([1746,1152],0,36342288,180)
    {
    Name = "V2rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   -Wire-([378,630],0,0,-1)
    {
    Vertex="0,0;-144,0"
    }
   -Wire-([1134,630],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   0.datalabel([1170,756],0,0,-1)
    {
    Name = "F4"
    }
   0.datalabel([1170,738],0,0,-1)
    {
    Name = "FT4"
    }
   -Wire-([1188,630],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.pgb([1638,1368],0,36348048,1030)
    {
    Name = "P1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-150"
    Max = "150"
    }
   -Wire-([234,1260],0,0,-1)
    {
    Vertex="0,0;0,288"
    }
   -Wire-([1404,126],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   0.datalabel([1350,126],4,0,-1)
    {
    Name = "Breaker"
    }
   0.datalabel([1062,1152],0,0,-1)
    {
    Name = "Breaker"
    }
   0.var_pot([1026,1350],0,36353584,400)
    {
    Name = "Fault location"
    Group = ""
    Display = "0"
    NDP = "6"
    Value = "5"
    F1 = "1.0"
    F2 = "2.0"
    F3 = "3.0"
    F4 = "4.0"
    F5 = "5.0"
    F6 = "6.0"
    F7 = "7.0"
    F8 = "8.0"
    F9 = "9.0"
    F10 = "10.0"
    }
   0.unity([1098,1350],0,0,420)
    {
    IType = "2"
    OType = "1"
    }
   0.datalabel([1962,1206],2,0,-1)
    {
    Name = "V4"
    }
   0.mux_array([1116,1422],6,0,610)
    {
    DPath = "0"
    }
   -Wire-([1188,1152],0,0,-1)
    {
    Vertex="0,0;-126,0"
    }
   0.datatap([1098,1134],6,0,650)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1134,1134],6,0,640)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1170,1134],6,0,630)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1206,1134],6,0,620)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1044,1224],6,0,1240)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1080,1224],6,0,1230)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1116,1224],6,0,1220)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1152,1224],6,0,1210)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1188,1224],6,0,1200)
    {
    Index = "5"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1224,1224],6,0,1190)
    {
    Index = "6"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1152,1224],2,0,-1)
    {
    Name = "FT4"
    }
   -Wire-([1206,1242],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   0.datatap([1044,1476],0,0,920)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1080,1476],0,0,910)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1116,1476],0,0,880)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1152,1476],0,0,870)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1188,1476],0,0,850)
    {
    Index = "5"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1224,1476],0,0,840)
    {
    Index = "6"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1224,1224],2,0,-1)
    {
    Name = "FT6"
    }
   0.datalabel([1188,1476],0,0,-1)
    {
    Name = "F5"
    }
   -Wire-([1206,1458],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   0.datalabel([1152,1476],0,0,-1)
    {
    Name = "F4"
    }
   0.datalabel([1350,144],4,0,-1)
    {
    Name = "Faulttype"
    }
   -Wire-([1350,144],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.breaker3([1098,738],0,0,660)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B4"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I4A"
    IBRB = "I4B"
    IBRC = "I4C"
    IBR0 = "I40"
    SBRA = "Br4A"
    SBRB = "Br4B"
    SBRC = "Br4C"
    BP = "P4"
    BQ = "Q4"
    BOpen1 = "2"
    BOpen2 = "2"
    BOpen3 = "2"
    P = "0.07075 [MW]"
    Q = "0.09075 [MVAR]"
    }
   0.var_pot([1206,1350],2,36385424,470)
    {
    Name = "Fault Type"
    Group = ""
    Display = "0"
    NDP = "10"
    Value = "4"
    F1 = "1.0"
    F2 = "2.0"
    F3 = "3.0"
    F4 = "4.0"
    F5 = "5.0"
    F6 = "6.0"
    F7 = "7.0"
    F8 = "8.0"
    F9 = "9.0"
    F10 = "0"
    }
   0.unity([1134,1350],4,0,590)
    {
    IType = "2"
    OType = "1"
    }
   0.datalabel([1134,1350],1,0,-1)
    {
    Name = "Faulttype"
    }
   -Wire-([1134,1314],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.pgb([2196,1368],0,36390592,890)
    {
    Name = "P3"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-150"
    Max = "150"
    }
   -Wire-([306,630],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.var([216,702],3,36393968,60)
    {
    Name = "Ph Angle"
    Group = "SS1"
    Display = "0"
    Max = "180"
    Min = "0.0"
    Value = "0.0"
    Units = "deg"
    Collect = "1"
    }
   0.var([162,702],3,36396952,50)
    {
    Name = "Voltage"
    Group = "SS1"
    Display = "0"
    Max = "500"
    Min = "0.0"
    Value = "230.0"
    Units = "kV"
    Collect = "1"
    }
   0.var([1314,702],5,36399808,90)
    {
    Name = "Voltage"
    Group = "SS2"
    Display = "0"
    Max = "500"
    Min = "0.0"
    Value = "230.0"
    Units = "kV"
    Collect = "1"
    }
   0.source3R([198,630],6,0,560)
    {
    Name = "Source1"
    MVA = "100.0 [MVA]"
    Vm = "230.0 [kV]"
    F = "$(f)"
    Tc = "0.05 [s]"
    Ideal = "0"
    ZSeq = "1"
    Imp = "1"
    View = "1"
    details = "1"
    Z1 = "52.9 [ohm]"
    Phi1 = "80.0 [deg]"
    R1p = "1.0 [ohm]"
    X1p = "0.1 [ohm]"
    Z0 = "52.9 [ohm]"
    Phi0 = "80.0 [deg]"
    R0p = "1.0 [ohm]"
    X0p = "0.1 [ohm]"
    P = "S1W"
    Q = "S1Q"
    Ia = ""
    Ib = ""
    Ic = ""
    }
   0.source3R([1278,630],2,0,570)
    {
    Name = "Source2"
    MVA = "100.0 [MVA]"
    Vm = "230.0 [kV]"
    F = "$(f)"
    Tc = "0.05 [s]"
    Ideal = "0"
    ZSeq = "1"
    Imp = "1"
    View = "1"
    details = "1"
    Z1 = "52.9 [ohm]"
    Phi1 = "80.0 [deg]"
    R1p = "1.0 [ohm]"
    X1p = "0.1 [ohm]"
    Z0 = "52.9 [ohm]"
    Phi0 = "80.0 [deg]"
    R0p = "1.0 [ohm]"
    X0p = "0.1 [ohm]"
    P = "S2W"
    Q = "S2Q"
    Ia = ""
    Ib = ""
    Ic = ""
    }
   0.var([1260,702],3,36406632,80)
    {
    Name = "Phase-S2"
    Group = "SS2"
    Display = "0"
    Max = "180"
    Min = "0.0"
    Value = "20.0"
    Units = ""
    Collect = "1"
    }
   -Wire-([990,738],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   0.tpflt([288,720],0,0,1300)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([504,756],0,0,1290)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([504,522],0,0,1320)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([1008,756],4,0,1270)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([1008,522],4,0,1310)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([1206,720],4,0,1280)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   -Wire-([1116,1530],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([1188,1530],0,0,-1)
    {
    Name = "Ron"
    }
   0.breakout2([648,630],4,0,-1)
    {
    }
   -Wire-([612,666],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([486,738],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([612,522],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([486,522],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   0.breakout2([864,630],0,0,-1)
    {
    }
   -Wire-([900,522],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([1026,522],0,0,-1)
    {
    Vertex="0,0;-126,0"
    }
   -Wire-([900,666],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([1026,738],0,0,-1)
    {
    Vertex="0,0;-126,0"
    }
   0.pgb([2034,1152],0,36425448,210)
    {
    Name = "V4rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   0.pgb([1908,1152],0,36428360,190)
    {
    Name = "V3rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   0.annotation([1062,1512],0,0,-1)
    {
    AL1 = "Rf"
    AL2 = ""
    }
   0.recorder2_0([810,1404],0,0,1090)
    {
    FName = "stn4"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "4"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V2a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V2b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V2c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I2a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I2b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I2c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.datalabel([918,1476],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([918,1296],0,0,-1)
    {
    Name = "Fault"
    }
   0.pgb([1638,1440],0,36445056,820)
    {
    Name = "PS1"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   0.pgb([1638,1476],0,36447800,740)
    {
    Name = "QS1"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.pgb([1764,1440],0,36450768,790)
    {
    Name = "PS2"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   0.pgb([1764,1476],0,36453680,720)
    {
    Name = "QS2"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   -Bus-([1134,504],0,41223528,-1)
    {
    P1 = [0,0]
    P2 = [0,252]
    I = 1
    NAME = BUS2
    BASKV = 0
    IDE = 0
    GL = 0
    BL = 0
    AREA = 1
    ZONE = 0
    VM = 0
    VA = 0
    OWNER = 1
    }
   -Bus-([378,504],0,41224904,-1)
    {
    P1 = [0,0]
    P2 = [0,252]
    I = 1
    NAME = BUS1
    BASKV = 0
    IDE = 0
    GL = 0
    BL = 0
    AREA = 1
    ZONE = 0
    VM = 0
    VA = 0
    OWNER = 1
    }
   .Plots_B1([414,396],0,0,10)
    {
    }
   -Sticky-([18,18],0)
    {
    Name = ""
    Font = 1
    Bounds = 18,18,576,180
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
Description: 
- Two Thevinen Impedance sources connected via two parallel 100km transmission lines on the same tower.
- System voltage is 230kV settable via source equivalents.
- Simulates two substations connected via two transmission lines.
- Six fault positions for full fault control ahead and behind station relays.
- Four breakers are independently timed controlled. (Default is closed).
- Independent breaker pole tripping is possible."
    }
   0.const([108,1188],1,0,120)
    {
    Name = ""
    Value = "10.0"
    }
   0.pgb([2034,1314],0,36462040,530)
    {
    Name = "V4c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "200.0"
    }
   0.pgb([1476,1278],0,36465136,320)
    {
    Name = "V2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   -Sticky-([1278,1116],0)
    {
    Name = ""
    Font = 1
    Bounds = 1278,1116,1386,1152
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "OUTPUT CHANNELS"
    }
   0.mux_array([1116,1278],0,0,1180)
    {
    DPath = "0"
    }
   0.var([1080,1530],0,36469416,550)
    {
    Name = "Rf"
    Group = ""
    Display = "0"
    Max = "50"
    Min = "0.001"
    Value = "0.001"
    Units = "ohm"
    Collect = "1"
    }
   0.recorder2_0([810,1224],0,0,1250)
    {
    FName = "stn3"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "3"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V1a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V1b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V1c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I1a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I1b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I1c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.recorder2_0([360,1404],0,0,1150)
    {
    FName = "stn2"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "2"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V2a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V2b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V2c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I2a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I2b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I2c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.var([72,1548],0,36494392,540)
    {
    Name = "Stop"
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.5"
    Units = "s"
    Collect = "1"
    }
   -Wire-([666,1548],0,0,-1)
    {
    Vertex="0,0;-558,0"
    }
   0.const([108,1368],1,0,240)
    {
    Name = ""
    Value = "10.0"
    }
   0.select([144,1404],6,0,300)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.select([144,1224],6,0,580)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.const([576,1188],1,0,140)
    {
    Name = ""
    Value = "10.0"
    }
   -Wire-([180,1224],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([558,1530],0,0,-1)
    {
    Vertex="0,0;-504,0"
    }
   -Wire-([576,1260],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([108,1260],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   -Wire-([108,1440],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   -Wire-([54,1260],0,0,-1)
    {
    Vertex="0,0;0,270"
    }
   0.var([18,1260],0,36504136,150)
    {
    Name = "Start"
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.15"
    Units = "s"
    Collect = "1"
    }
   -Wire-([180,1404],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.select([612,1404],6,0,450)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   -Wire-([576,1440],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.const([576,1368],1,0,330)
    {
    Name = ""
    Value = "10.0"
    }
   -Wire-([648,1404],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.select([612,1224],6,0,160)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   -Wire-([558,1260],0,0,-1)
    {
    Vertex="0,0;0,270"
    }
   0.var_switch([144,1152],1,36511280,110)
    {
    Name = "en Record1"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var_switch([144,1332],1,36514168,200)
    {
    Name = "en Record2"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var_switch([612,1152],1,36516896,130)
    {
    Name = "en Record3"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var_switch([612,1332],1,36519616,270)
    {
    Name = "en Record4"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   -Wire-([666,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([666,1260],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([648,1224],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([666,1260],0,0,-1)
    {
    Vertex="0,0;0,288"
    }
   -Wire-([234,1260],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   .Plots_B2([1080,396],0,0,20)
    {
    }
   -TLine-([648,630],0,41502272,-1)
    {
    Name = "L1_2"
    Date = 1144771583
    Freq = "$(f)"
    Length = "100.0 [km]"
    Dim = 6
    Mode = 1
    Vertex="0,0;18,0;198,0;216,0"
    PageLayer(A/A4,Landscape,18,[597,467],100)
     {
     0.Line_FrePhase_Options([216,486],0,41504160,-1)
      {
      Interp1 = "1"
      Output = "0"
      Inflen = "0"
      FS = "0.5 [Hz]"
      FE = "1.0E6 [Hz]"
      Numf = "100"
      YMaxP = "20"
      AMaxP = "20"
      YMaxE = "2 [%]"
      AMaxE = "2 [%]"
      xxx = ""
      W1 = "100"
      W2 = "1000"
      W3 = "1"
      }
     0.Line_Ground([630,702],0,41526304,-1)
      {
      GRRES = "100.0 [ohm*m]"
      GPERM = "1.0"
      EarthForm = "0"
      }
     0.Line_Tower_6_Concent([756,576],0,41526672,-1)
      {
      TName = "3L12"
      Y = "30 [m]"
      Y2 = "5 [m]"
      XC = "10 [m]"
      X2 = "2 [m]"
      X = "0 [m]"
      ShuntG = "1.0E-10 [mho/m]"
      SHSag = "0"
      Transp = "1"
      NG = "2"
      ElimGW = "1"
      CDataType = "1"
      CName = "chukar"
      CLName = "..conductor.clb"
      RadiusC = "0.0203454 [m]"
      DCResC = "0.03206 [ohm/km]"
      SAGC = "10 [m]"
      NCondB = "1"
      BundSym = "0"
      SHBund = "1"
      BSP = ".4572 [m]"
      GDataType = "1"
      GName = "1/2\"HighStrengthSteel"
      GLName = "..\\conductor.clb"
      RadiusG = "0.0055245 [m]"
      DCResG = "2.8645 [ohm/km]"
      SAGG = "10 [m]"
      YG = "15 [m]"
      XG = "10 [m]"
      XB1 = "-0.1 [m]"
      YB1 = "0.1 [m]"
      XB2 = "-0.1 [m]"
      YB2 = "0.1 [m]"
      XB3 = "-0.1 [m]"
      YB3 = "0.1 [m]"
      XB4 = "-0.1 [m]"
      YB4 = "0.1 [m]"
      XB5 = "-0.1 [m]"
      YB5 = "0.1 [m]"
      XB6 = "-0.1 [m]"
      YB6 = "0.1 [m]"
      XB7 = "-0.1 [m]"
      YB7 = "0.1 [m]"
      XB8 = "-0.1 [m]"
      YB8 = "0.1 [m]"
      XB9 = "-0.1 [m]"
      YB9 = "0.1 [m]"
      XB10 = "-0.1 [m]"
      YB10 = "0.1 [m]"
      NC1 = "1"
      NC2 = "2"
      NC3 = "3"
      NC4 = "4"
      NC5 = "5"
      NC6 = "6"
      NG1 = "7"
      NG2 = "8"
      }
     }
    }
   -Sticky-([1224,522],0)
    {
    Name = ""
    Font = 1
    Bounds = 1224,522,1314,558
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "SUBSTATION 2"
    }
   -Sticky-([144,522],0)
    {
    Name = ""
    Font = 1
    Bounds = 144,522,234,558
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "SUBSTATION 1"
    }
   .Controls([1440,162],4,0,600)
    {
    }
   -Divider-([36,1026],0)
    {
    Size(2340,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Sticky-([720,36],0)
    {
    Name = ""
    Font = 1
    Bounds = 720,36,1116,144
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
This case uses global substitutions.  To change between 50Hz/60Hz. select Global Substitutions (Ctrl-G).  In the pop-up window, change the value of f to the desired frequency.
"
    }
   0.multimeter([468,522],0,0,30)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V1"
    P = ""
    Q = ""
    Vrms = "V1rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.multimeter([468,738],0,0,70)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V3"
    P = ""
    Q = ""
    Vrms = "V3rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.multimeter([1044,738],4,0,100)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V4"
    P = ""
    Q = ""
    Vrms = "V4rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.multimeter([1044,522],4,0,40)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V2"
    P = ""
    Q = ""
    Vrms = "V2rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.datalabel([1602,1152],0,0,-1)
    {
    Name = "V1rms"
    }
   -Wire-([1602,1152],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1710,1152],0,0,-1)
    {
    Name = "V2rms"
    }
   -Wire-([1710,1152],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1872,1152],0,0,-1)
    {
    Name = "V3rms"
    }
   -Wire-([1872,1152],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1998,1152],0,0,-1)
    {
    Name = "V4rms"
    }
   -Wire-([1998,1152],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   }
  }
 }

